--require 'File Functions'

File = {
CollectFilesToTable = function (self, path, ext)
	local i = 1
	local files = {}
	for fa in win.Files (path.."*."..ext) do
		if math.band (fa.FileAttributes, win.FILE_ATTRIBUTE_DIRECTORY) == 0 then
				files[i] = path..fa.FileName
		end;
		i = i + 1
	end;
	return files
end;
--name: String. File path and name. May include wildcards. 
DoesFileExist = function (self, name)
	local res, err
	res, err = win.FileExists(name);
	--if err then print ("Error, Finding File: "..err) end;
	if res then res = true else res = false end
	return res;
end;
--path: String. Directory path (no trailing backslash).
DoesDirectoryExist = function (self, path)
	local res, err
	res, err = win.PathExists(path)
	--if err then print ("Error, Finding Directory: "..err) end;
	if res then res = true else res = false end
	return res--, err;
end;
--path: String. Directory path (no trailing backslash). 
CreateDirectory = function (self, path)
	local res, err
	res, err = win.CreateDirectory(path)
	--if err then print ("Error, Creating Directory: "..err) end;
	return res, err;
end;
--path: String. Directory path (no trailing backslash).
DeleteDirectory = function (self, path)
	local res, err
	res, err = win.RemoveDirectory(path)
	--if err then print ("Error, Deleting Directory: "..err) end;
	return res, err;
end;
--path: String. Directory path (no trailing backslash).
DeleteFile = function (self, path)
	local res, err
	res, err = win.DeleteFile(path)
 	--if err then print ("Error, Deleting File: "..err) end;
	return res, err;
end;
--Supports wildcards 
MoveFile = function (self, pathfrom, pathto)
	local res, err
	res, err = win.SHFileOperation(pathfrom, pathto, win.FO_MOVE, win.FOF_NORECURSION)
	--if err then print ("Error, Moving File: "..err) end;
	return res, err;
end;
--Supports wildcards
RenameFile = function (self, nameold, namenew)
	local res, err
	res, err = win.SHFileOperation(nameold, namenew, win.FO_RENAME, win.FOF_NORECURSION)
	--if err then print ("Error, Rename File: "..err) end;
	return res, err;
end;
--Supports wildcards
CopyFile = function (self, filetocopy, copiedfilename)
	local res, err
	res, err = win.SHFileOperation(filetocopy, copiedfilename, win.FO_COPY, win.FOF_NORECURSION)
	--if err then print ("Error, Copy File: "..err) end;
	return res, err;
end;

WriteTextToLogFile = function (self, filename, valtab)
	local f = io.open (filename, "a+")
	local val = ""
	local val = os.date ()..","
	for i,v in pairs (valtab) do
		val = val..v..","
	end;
	val = val.."\n"
	f:write (val)
	f:close (filename)
	return f
end;
}
gir.LogMessage("File Functions","Script Loaded",3);

--Actions
--Does File Exist
treescript.Action[60]={

    OnAction=function ( Action, Event )
        local file = Action.sValue1

	local ids = gir.ParseString(Action.sValue3);
	local strids = string.Split(ids, ",");
	local trueID = tonumber(strids[1]);
	local falseID = tonumber(strids[2]);
	local trueFileGUID = strids[3];
	local falseFileGUID = strids[4];
	
	if File:DoesFileExist (file) then
		gir.TriggerNode(trueFileGUID, trueID, true);
	else
		gir.TriggerNode(falseFileGUID, falseID, true);
	end
       return
    end,
    
    OnShow=function ( Index, Action, Controls)
		local ids = gir.ParseString(Action.sValue3);
		local strids = string.Split(ids, ",");
		Controls.jumptrue.ID = tonumber(strids[1]);
		Controls.jumpfalse.ID = tonumber(strids[2]);
		Controls.jumptrue.FileGUID = strids[3];
		Controls.jumpfalse.FileGUID = strids[4];
		treescript.UpdateDUIPage(Index)	
    end,
    
    OnApply=function ( Index, Action, Controls)
	Action.sValue3 = string.format("%s,%s,%s,%s",Controls.jumptrue.ID,Controls.jumpfalse.ID,Controls.jumptrue.FileGUID,Controls.jumpfalse.FileGUID)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}

--Does Folder Exist
treescript.Action[61]={

    OnAction=function ( Action, Event )
	local file = Action.sValue1

	local ids = gir.ParseString(Action.sValue3);
	local strids = string.Split(ids, ",");
	local trueID = tonumber(strids[1]);
	local falseID = tonumber(strids[2]);
	local trueFileGUID = strids[3];
	local falseFileGUID = strids[4];
	
	if File:DoesFileExist (file) then
		gir.TriggerNode(trueFileGUID, trueID, true);
	else
		gir.TriggerNode(falseFileGUID, falseID, true);
	end
       return
    
    end,
    
    OnShow=function ( Index, Action, Controls)
    		local ids = gir.ParseString(Action.sValue3);
		local strids = string.Split(ids, ",");
		Controls.jumptrue.ID = tonumber(strids[1]);
		Controls.jumpfalse.ID = tonumber(strids[2]);
		Controls.jumptrue.FileGUID = strids[3];
		Controls.jumpfalse.FileGUID = strids[4];
		treescript.UpdateDUIPage(Index)	
    end,
    
    OnApply=function ( Index, Action, Controls)
    	Action.sValue3 = string.format("%s,%s,%s,%s",Controls.jumptrue.ID,Controls.jumpfalse.ID,Controls.jumptrue.FileGUID,Controls.jumpfalse.FileGUID)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--Create Directory
treescript.Action[62]={

    OnAction=function ( Action, Event )
        local file = Action.sValue1
        return File:CreateDirectory (file)
    end,
    
    OnShow=function ( Index, Action, Controls)
    end,
    
    OnApply=function ( Index, Action, Controls)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--Delete Directory
treescript.Action[63]={

    OnAction=function ( Action, Event )
        local file = Action.sValue1
        return File:DeleteDirectory (file)
    end,
    
    OnShow=function ( Index, Action, Controls)
    end,
    
    OnApply=function ( Index, Action, Controls)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--Delete File
treescript.Action[64]={

    OnAction=function ( Action, Event )
        local file = Action.sValue1
        return File:DeleteFile (file)
    end,
    
    OnShow=function ( Index, Action, Controls)
    end,
    
    OnApply=function ( Index, Action, Controls)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--Move File
treescript.Action[65]={

    OnAction=function ( Action, Event )
        local from = Action.sValue1
	local to = Action.sValue2
        return File:MoveFile(from, to)
    end,
    
    OnShow=function ( Index, Action, Controls)
    end,
    
    OnApply=function ( Index, Action, Controls)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--Rename File
treescript.Action[66]={

    OnAction=function ( Action, Event )
        local from = Action.sValue1
	local to = Action.sValue2
        return File:RenameFile (from, to)
    end,
    
    OnShow=function ( Index, Action, Controls)
    end,
    
    OnApply=function ( Index, Action, Controls)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--Copy File
treescript.Action[67]={

    OnAction=function ( Action, Event )
        local from = Action.sValue1
	local to = Action.sValue2
        return File:CopyFile (from, to)
    end,
    
    OnShow=function ( Index, Action, Controls)
    end,
    
    OnApply=function ( Index, Action, Controls)
    end,

    OnDefaults=function (Index, Action)
    end,
    
    OnEvent= function (Index, Action, Controls, Control, ID1, ID2)
    end,
    
    OnClose =function (Index, Action, Controls)
    end,
}
--File Conditional
treescript.Conditional[111] = {

OnAction = function(Action, Event)

    if (tonumber(Action.bValue1) == 0) then
	return File:DoesFileExist (Action.sValue1)
    else
        return not File:DoesFileExist (Action.sValue1)
    end
end,

OnDefaults = function(Index, Action)
    Action.sValue1 = ""; Action.bValue1 = "0"
end,

OnShow = function(Index, Action, Controls)
end,

OnApply = function(Index, Action, Controls)
end
}
--Folder Conditional
treescript.Conditional[112] = {

OnAction = function(Action, Event)

    if (tonumber(Action.bValue1) == 0) then
	return File:DoesDirectoryExist (Action.sValue1)
    else
        return not File:DoesDirectoryExist (Action.sValue1)
    end
end,

OnDefaults = function(Index, Action)
    Action.sValue1 = ""; Action.bValue1 = "0"
end,

OnShow = function(Index, Action, Controls)
end,

OnApply = function(Index, Action, Controls)
end
}
return "File Functions UI.xml"
